import java.awt.*;

public class WindowUtils extends Object{
  static public Component getMainWindow(Component c) {
      Component parent = c.getParent();
      while(true){
	//System.out.println(parent.toString());
	if(parent.getParent() == null)
	  break;
	else 
	  parent = parent.getParent();
      }
      return parent;    
  }

  static public void constrain(Container container, Component component, 
			int grid_x, int grid_y, int grid_width, int grid_height,
			int fill, int anchor, double weight_x, double weight_y,
			int left, int top, int right, int bottom)
    {
      GridBagConstraints c = new GridBagConstraints();
      c.gridx = grid_x; c.gridy = grid_y;
      c.gridwidth = grid_width; c.gridheight = grid_height;
      c.fill = fill; c.anchor = anchor;
      c.weightx = weight_x; c.weighty = weight_y;
      if (top+bottom+left+right > 0)
	c.insets = new Insets(top, left, bottom, right);
      
      ((GridBagLayout)container.getLayout()).setConstraints(component, c);
      container.add(component);
    }
  
  static public void constrain(Container container, Component component, 
			int grid_x, int grid_y, int grid_width, int grid_height) {
    constrain(container, component, grid_x, grid_y, 
              grid_width, grid_height, GridBagConstraints.NONE, 
              GridBagConstraints.NORTHWEST, 0.0, 0.0, 0, 0, 0, 0);
  }
  
  static public void constrain(Container container, Component component, 
			int grid_x, int grid_y, int grid_width, int grid_height,
			int left, int top, int right, int bottom) {
    constrain(container, component, grid_x, grid_y, 
              grid_width, grid_height, GridBagConstraints.NONE, 
              GridBagConstraints.NORTHWEST, 
              0.0, 0.0, top, left, bottom, right);
  }

}
