// ColorChooserApplet.java - an Applet to contain ColorChooser
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.


import java.awt.*;

public class ColorChooserApplet extends java.applet.Applet {

  ColorChooser colorChooser;
  GridBagLayout layout = new GridBagLayout();
  
  public void init() {

    colorChooser = new ColorChooser(new Color(128,128,190));

    this.setLayout(layout);
        
    Panel pPanel = new BorderPanel(BorderPanel.RAISED); pPanel.setLayout(layout);
    WindowUtils.constrain(this,pPanel,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);
    WindowUtils.constrain(pPanel, colorChooser,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);
  }

  public String getAppletInfo() {
    return getClass().getName() + 
      " - Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov.ic.ac.uk>.  All rights reserved.";
  }

  public static void main(String[] args) {
    ColorChooserApplet applet = new ColorChooserApplet();
    applet.init();
    Frame frame = new AppletFrame("ColorChooserApplet Test");
    frame.add("Center", applet);
    frame.resize(450, 400);
    frame.show();
  }
}


