import java.awt.*;

public class BorderPanel extends Panel
{
  int border = 2;	// size of border
  Color col1 = null;
  Color col2 = null;
  static final int RECESSED = 0, RAISED = 1; // PRESSED, DEPRESSED
  int state = RECESSED;
  public static int insets = 1;
  BorderPanel() {
  }
  BorderPanel(int state) {
    this.state = state;
  }
  
  BorderPanel(int w, Color c1, Color c2) {	
    border = w;
    col1 = c1; col2 = c2;
  }
  
  BorderPanel(Color c1, Color c2) {
    col1 = c1; col2 = c2;
  }
  
  public Insets insets() {
    return new Insets(border+insets, border+insets, border+insets, border+insets);
  }
  
  public void paint(Graphics g) {
    super.paint(g);
    int w = size().width-1, h = size().height-1;
    if(col1==null || col2==null){
      if(state == RECESSED){
	col1 = getBackground().darker();
	col2 = getBackground().brighter();
      } else {
	col2 = getBackground().darker();
	col1 = getBackground().brighter();
      }
    }
    g.setColor(col1);
    for(int i=0; i<border; i++) {
      g.drawLine(i,i,w-i,i);
      g.drawLine(i,i,i,h-i);
    }
    g.setColor(col2);
    for(int i=0; i<border; i++) {
      g.drawLine(w-i,h-i, w-i,i);
      g.drawLine(w-i,h-i, i,h-i);
    }
  }
}
