package PVS.Utils;

/*
 TabbedPanel
 A panel capable of displaying one of many components at a time. The
 component to display is chosen by a row of tab buttons.
 
*/

import java.awt.*;
import java.util.Vector;

public class TabbedPanel extends Panel
{
  TabSelector tab;		// component for choosing panel
  TabbedDisplayPanel disp;	// where other panels are displayed
  CardLayout card;
  Component parent;             // who to notify if sheet was changed
  String currentComponent = null;

  public TabbedPanel() {
    Color hi = new Color(230,230,230), lo = new Color(50,50,50);
    
    /*
       setLayout(new GridBagLayout());
       WindowUtils.constrain(this,tab = new TabSelector(hi, lo),0,0,1,1, 
       GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,0.1);
       WindowUtils.constrain(this,disp = new TabbedDisplayPanel(hi, lo),0,1,1,1, 
       GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.0);
       */
    
    setLayout(new BorderLayout());
    add("Center",disp = new TabbedDisplayPanel(hi, lo));
    add("North",tab = new TabSelector(hi, lo,disp));
    
    disp.setLayout(card = new CardLayout());
    currentComponent = null;
  }
  
  public TabbedPanel(Component parent) {
    this();
    this.parent = parent;
  }
  
  // addItem
  // Add a component to be chosen by a tab with the given name
  public void addItem(String n, Component c) {
    tab.addItem(n);
    disp.addItem(n, c);
    if(currentComponent == null){ // first component
      currentComponent = n;
    }
  }
  
  // select
  // Display a component in the panel
  public void select(String n) {
    tab.choose(n);
    disp.choose(n);
  }
  
  /**
       remove item with this name from selector
    */
  public void hideItem(String name){    
    tab.removeItem(name);
  }

  /**
      add item with this name to selector
    */
  public void showItem(String name){
    tab.addItem(name);    
  }
  
  /**
      changes name of specified item
    */
  public void renameItem(int item, String name){
    tab.renameItem(item,name);
  }

  // chose
  // Called back by a TabSelector object when the user clicks on a tab
  public void chose(String n) {
    disp.choose(n);
    currentComponent = n;
    if(parent != null){
      parent.postEvent(new Event(this,Event.ACTION_EVENT,n));
      //parent.deliverEvent(new Event(this,Event.ACTION_EVENT,n));
    }
  }
  
  
  public String getCurrentComponent(){
    return currentComponent;
  }
  
  public void setParent(Component parent){
    this.parent = parent;
  }
  
  public static void main(String[] args) {
    TabbedPanel panel = new TabbedPanel();
    int N = 20;
    for(int i=0;i<N;i++){
      panel.addItem(Integer.toString(i),new Button("Button:"+i));      
    }
    Frame frame = new Frame("TabbedPanel test");
    frame.add("Center", panel);
    frame.resize(600, 100);
    frame.show();
  }
}

class TabSelector extends Canvas
{
  Color hi, lo;
  Vector name = new Vector();
  Vector caption = new Vector();
  int chosen = 0;
  Font font = new Font("timesRoman", Font.PLAIN, 12),
  chfont = new Font(font.getName(), Font.BOLD, 13);
  TabbedDisplayPanel disp;

  TabSelector(Color h, Color l,TabbedDisplayPanel disp) {
    hi = h; lo = l; this.disp = disp;
  }
  
  void addItem(String n) {
    for(int i=0; i<name.size(); i++)
      if (((String)name.elementAt(i)).equals(n)) {
	return; // we should not do anything
      }
    name.addElement(n);
    caption.addElement(n);
    repaint();
  }
  
  void choose(String n) {
    for(int i=0; i<name.size(); i++)
      if (((String)name.elementAt(i)).equals(n)) {
	chosen = i;
	repaint();
      }
  }

  /**
      changes name of specified item
    */
  void renameItem(int item, String newname){
    if(item >=0 && item < caption.size()){
      if(((String)caption.elementAt(item)).equals(newname))
	return; // we need to do nothing
      else {
	caption.setElementAt(newname,item);
	repaint();
      }
    }
  }

  void removeItem(String n) {
    for(int i=0; i<name.size(); i++)
      if (((String)name.elementAt(i)).equals(n)) {
	name.removeElementAt(i);
	if(chosen == i){
	  chosen = i-1;
	  if(chosen < 0){
	    chosen = name.size()-1;
	  }
	  disp.choose((String)name.elementAt(chosen));
	}
	repaint();
	return;
      }
  }

  public void update(Graphics g){
    paint(g);
  }

  public void paint(Graphics g) {
    if (g == null || name.size() == 0)
      return;
    g.setColor(Color.lightGray);
    g.fillRect(0, 0, size().width, size().height);
    int tw = size().width / name.size(),
    th = size().height;
    for(int i=0; i<name.size(); i++) {
      int x = tw*i;
      if (i == chosen) {
	g.setColor(lo);
	g.drawLine(x+tw-3, 1, x+tw-3, th-1);
	g.drawLine(x+tw-4, 2, x+tw-4, th-1);
	g.setColor(hi);
	g.drawLine(x, 0, x, th-1);
	g.drawLine(x+1, 0, x+1, th-1);
	g.drawLine(x, 0, x+tw-4, 0);
	g.drawLine(x, 1, x+tw-5, 1);
	g.drawLine(x+tw-3, th-1, x+tw-1, th-1);
	g.drawLine(x+tw-3, th-2, x+tw-1, th-2);
      } else {
	g.setColor(lo);
	g.drawLine(x+tw-3, 6, x+tw-3, th-1);
	g.drawLine(x+tw-4, 7, x+tw-4, th-1);
	g.setColor(hi);
	g.drawLine(x, 5, x, th-1);
	g.drawLine(x+1, 5, x+1, th-1);
	g.drawLine(x, 5, x+tw-4, 5);
	g.drawLine(x, 6, x+tw-5, 6);
	g.drawLine(x, th-1, x+tw-1, th-1);
	g.drawLine(x, th-2, x+tw-1, th-2);
      }
      g.setColor(lo);
      if (i == chosen) g.setFont(chfont);
      else g.setFont(font);
      String str = (String)caption.elementAt(i);
      int textw = g.getFontMetrics().stringWidth(str);
      int texth = g.getFontMetrics().getHeight();
      if (textw < tw-5)
	g.drawString(str, x+(tw-textw)/2, (th-texth)/2+texth);
    }
  }
  
  public boolean mouseDown(Event evt, int x, int y)
    {
      if (name.size() == 0) return false;
      chosen = x / (size().width / name.size());
      paint(getGraphics());
      ((TabbedPanel)getParent()).chose((String)name.elementAt(chosen));
      return true;
    }
  
  public Dimension minimumSize()
    {
      return new Dimension(50,25);
    }
  
  public Dimension preferredSize()
    {
      return minimumSize();
    }
}

class TabbedDisplayPanel extends Panel
{
  Color hi, lo;
  CardLayout card;
  
  TabbedDisplayPanel(Color h, Color l)
    {
      hi = h; lo = l;
      setLayout(card = new CardLayout());
    }
  
  // addItem
  // Add one component to the set of possibles to be shown
  void addItem(String n, Component c)
    {
      add(n, c);
    }
  
  // choose
  // Display the named panel
  void choose(String n)
    {
      ((CardLayout)getLayout()).show(this, n);
    }
  
  public Insets insets()
    {
      return new Insets(5,5,5,5);
    }
  
  public void paint(Graphics g)
    {
      g.setColor(hi);
      g.drawLine(0, 0, 0, size().height-1);
      g.drawLine(1, 0, 1, size().height-1);
      g.setColor(lo);
      g.drawLine(0, size().height-1, size().width-1, size().height-1);
      g.drawLine(0, size().height-2, size().width-1, size().height-2);
      g.drawLine(size().width-1, size().height-1, size().width-1, 0);
      g.drawLine(size().width-2, size().height-1, size().width-2, 0);
    }
}
