package PVS.Utils;

import java.awt.*;

public class DoubleField extends Panel{
  static public final int TEXTLEN = 6;
  public DoubleR value = null;
  public TextField textField;

  public DoubleField(String label, DoubleR value,GridBagLayout layout, int width) {

    this.textField = new TextField(width);  
    this.value = value; 
    textField.setText(value.toString());
    
    this.setLayout(layout);
    int x = 0;
    if(label != null)
      WindowUtils.constrain(this,new Label(label),x++,0,1,1,GridBagConstraints.NONE,
			    GridBagConstraints.EAST,1.,1.,5,0,0,0);
    WindowUtils.constrain(this,textField,x,0,1,1,GridBagConstraints.NONE,
			  GridBagConstraints.WEST,1.,1.,0,0,0,0);
  }

  public DoubleField(String label, DoubleR value,GridBagLayout layout) {
    this(label,value,layout,TEXTLEN);
  }

  public DoubleField(String label, DoubleR value) {
    this(label,value,new GridBagLayout());
  }

  /**
    assign new value to editable
   */
  public void setValue(double newvalue){
    this.value.value = newvalue;
    updateField();
  }

  /**
    set new editable value
   */
  public void setValue(DoubleR newvalue){
    this.value = newvalue;
    updateField();
  }

  public void updateField(){
    textField.setText(value.toString()); 
  }
  public void readField(){
    value.value =  (Double.valueOf(textField.getText())).doubleValue();
  }
  public boolean action(Event e,Object what){
    if(e.target == textField){
      readField();
    }
    return false;
  }
  public boolean lostFocus(Event e,Object what) {
    if(e.target == textField){
      readField();
    }
    return false;
  }  
}
