package PVS.POVTextureEditor;
// TextureEditorProperties.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.awt.*;
import java.util.Properties;

import PVS.Utils.*;

class TextureEditorProperties extends Dialog{

  Button buttonOK = new Button("OK");
  Button buttonCancel = new Button("Cancel");
  String result = null;
  Component notifyParent = null;

  Checkbox   gammaField;
  DoubleField   gammaValueField;
  StringField   povrayField,homeField;

  StringR povray = new StringR();
  StringR home = new StringR();
  DoubleR gammaValue = new DoubleR(ImageTGA.red_gamma);   

  GridBagLayout layout = new GridBagLayout();

  TextureEditorProperties(Frame frame,String title,boolean modal){
    super(frame,title,modal);
    
    povray.value =  System.getProperties().getProperty("povray.path");
    home.value =  System.getProperties().getProperty("home");

    this.setLayout(layout);
    gammaField = new Checkbox(" gamma correction",null,ImageTGA.doGamma);
    gammaValueField = new DoubleField("gamma value:",gammaValue,layout);
    povrayField = new StringField("povray path:",povray,layout,30);
    homeField = new StringField("POVTextureEditor home:",home,layout,30);

    Panel panel1 = new BorderPanel();panel1.setLayout(layout);
    WindowUtils.constrain(panel1,gammaField,0,0,1,1, GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(panel1,gammaValueField,1,0,1,1, 
			  GridBagConstraints.NONE,
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(panel1,povrayField,0,1,2,1, GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(panel1,homeField,0,2,2,1, GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);

    Panel panel2 = new BorderPanel();panel2.setLayout(layout);
    WindowUtils.constrain(panel2,buttonOK,0,0,1,1, GridBagConstraints.NONE,
			  GridBagConstraints.CENTER,1.,1.);
    WindowUtils.constrain(panel2,buttonCancel,1,0,1,1, 
			  GridBagConstraints.NONE, 
			  GridBagConstraints.CENTER,1.,1.);

    WindowUtils.constrain(this,panel1,0,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.CENTER,1.,1.);
    WindowUtils.constrain(this,panel2,0,1,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.CENTER,1.,1.);
  }
  
  public boolean action(Event e, Object o){
    if(e.target == buttonOK){

      if(gammaField.getState())
	ImageTGA.doGamma=true;
      else
	ImageTGA.doGamma=false;
      
      ImageTGA.red_gamma = ImageTGA.blue_gamma = ImageTGA.green_gamma = 
	gammaValue.value;

      Properties props = System.getProperties();
      props.put("povray.path",povray.value);
      props.put("home",home.value);
      props.put("gamma.value",""+ImageTGA.red_gamma);
      props.put("gamma",ImageTGA.doGamma ? "true":"false");
      System.setProperties(props);


      this.hide();
      Toolkit.getDefaultToolkit().sync();      
      this.dispose();
      return true;
    } else if(e.target == buttonCancel){
      this.dispose();
      return true;
    }
    return false;
  }  
}
