package PVS.POVTextureEditor;
// SamplePanel.java - (from POVray  Texture editor)
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.


import java.awt.*;
import java.io.*;
import java.util.*;

import PVS.Utils.*;

class SamplePanel extends Canvas implements Observer {

  Drawable drawable = null;

  public SamplePanel() {
  }

  public Dimension preferredSize(){
    return new Dimension(150,150);
  }

  public Dimension minimumSize(){
    return new Dimension(50,50);
  }

  public void update(Graphics g){
    paint(g);
  }

  public void paint(Graphics g) {
    if(drawable != null)
      drawable.draw(g,size().width,size().height);
    else {
      g.setColor(Color.gray);
      g.fillRect(0,0,size().width,size().height);
      g.setColor(Color.black);
      g.drawLine(0,0,size().width,size().height);
      g.drawLine(0,size().height,size().width,0);
    }
  }    

  void setDrawable(Drawable o){
    drawable = o;
    repaint();
  }

  void unsetDrawable(){
    drawable = null;
    repaint();    
  }
  
  /**
    our drawable had changed his look and inform us about it
   */
  public void update(Observable o, Object arg){
    
    //if((Object)drawable == arg)
    {
      repaint();
    }
  }

}
