package PVS.POVTextureEditor;
// PigmentEditor.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.awt.*;

import PVS.Utils.*;


public class PigmentEditor extends Panel {

  GridBagLayout layout = new GridBagLayout();
  ColorMapEditor colorMapEditor = null;
  Frame colorMapFrame = null;
  ColorEditor colorEditor = new ColorEditor(new ColorExt());
  ColorMapPanel colorMapPanel;
  ColorEditor colorMapColorEditor;

  POVPigment pigment;

  DoubleField octaves,omega,lambda,frequency,phase,agate_turb;
  DoubleField[] scale = new DoubleField[3];
  DoubleField[] rotate = new DoubleField[3];
  DoubleField[] translate = new DoubleField[3];

  DoubleField[] direction = new DoubleField[3];
  DoubleField[] turbulence = new DoubleField[3];
  ChoiceField   type;
  
  Panel pDir,pTurb,pProp;
  TabbedPanel panelPigment;
  Panel colorPanel;

  PigmentEditor(POVPigment pigment){
    this.pigment = pigment;

    this.setLayout(layout);

    panelPigment = new TabbedPanel(this);
    panelPigment.addItem("Params",createParamsPanel());
    panelPigment.addItem("Transform",createTransformPanel());
    panelPigment.addItem("ColorMap",createColorMapPanel());

    WindowUtils.constrain(this,panelPigment,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.0,1.0);
  }  

  Component createParamsPanel(){
    Panel pAll = new Panel(); pAll.setLayout(layout);

    type = new ChoiceField("Type",pigment.type);
    
    Panel pType = new BorderPanel(); pType.setLayout(layout);    
    WindowUtils.constrain(pType,type,0,0,1,1,GridBagConstraints.NONE,
                          GridBagConstraints.CENTER,1.0,1.0);
    
    pTurb = new BorderPanel(); pTurb.setLayout(layout);    
    WindowUtils.constrain(pTurb,new Label("Turbulence"),0,0,2,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER, 
			  1.0,0.0);
    for(int i=0;i<3;i++){
      placeEditControl(pTurb,turbulence[i] =  
		       new DoubleField(String.valueOf((char)('X'+i)),
				       pigment.turbulence[i],layout),0,i+1);
    }
    placeEditControl(pTurb,octaves = 
		     new DoubleField("octaves",pigment.octaves,layout),1,1);
    placeEditControl(pTurb,omega = 
		     new DoubleField("omega",pigment.omega,layout),1,2);
    placeEditControl(pTurb,lambda = 
		     new DoubleField("lambda",pigment.lambda,layout),1,3);


    pDir = new BorderPanel(); pDir.setLayout(layout);    
    WindowUtils.constrain(pDir,new Label("Direction"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,
			  1.0,0.0);
    for(int i=0;i<3;i++){
      placeEditControl(pDir,direction[i] = 
		       new DoubleField(String.valueOf((char)('X'+i)),
				       pigment.direction[i],layout),0,i+1);
    }

    pProp = new BorderPanel(); pProp.setLayout(layout);    
    frequency = new DoubleField("frequency",pigment.frequency,layout);
    placeEditControl(pProp,frequency,0,3);
    phase = new DoubleField("phase",pigment.phase,layout);
    placeEditControl(pProp,phase,0,4);
    agate_turb = new DoubleField("agate_turb",pigment.agate_turb,layout);
    placeEditControl(pProp,agate_turb,0,5);
    
    Panel pProp2 = new Panel(); pProp2.setLayout(layout);

    WindowUtils.constrain(pProp2,pDir,0,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.CENTER,1.,1.);
    WindowUtils.constrain(pProp2,pProp,0,1,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.CENTER,1.,1.);
    
    WindowUtils.constrain(pAll,pType,0,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pTurb,0,1,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pProp2,1,0,1,2, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST,1.,1.);
    return pAll;

  }

  Component createTransformPanel(){

    Panel pAll = new Panel(); pAll.setLayout(layout);

    Panel pScale = new BorderPanel(); pScale.setLayout(layout);    
    Panel pRotate = new BorderPanel(); pRotate.setLayout(layout);    
    Panel pTranslate = new BorderPanel(); pTranslate.setLayout(layout);    

    WindowUtils.constrain(pScale,new Label("Scale"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,
			  1.0,0.0);
    WindowUtils.constrain(pRotate,new Label("Rotate"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,
			  1.0,0.0);
    WindowUtils.constrain(pTranslate,new Label("Translate"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,
			  1.0,0.0);
    
    for(int i=0;i<3;i++){
      scale[i] = new DoubleField(String.valueOf((char)('X'+i)),
				 pigment.scale[i],layout);
      WindowUtils.constrain(pScale,scale[i],0,i+1, 1,1, 
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,
			    1.,1.);
      rotate[i] = new DoubleField(String.valueOf((char)('X'+i)),
				  pigment.rotate[i],layout);
      WindowUtils.constrain(pRotate,rotate[i],0,i+1, 1,1,
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,
			    1.,1.);
      translate[i] = new DoubleField(String. valueOf((char)('X'+i)),
				     pigment.translate[i],layout);
      WindowUtils.constrain(pTranslate,translate[i], 0,i+1, 1,1, 
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,
			    1.,1.);
    }

    WindowUtils.constrain(pAll,pScale,0,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST, 1.,1.);
    WindowUtils.constrain(pAll,pRotate,1,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pTranslate,2,0,1,1, GridBagConstraints.BOTH, 
			  GridBagConstraints.EAST,1.,1.);
    return pAll;
  }


  Component createColorMapPanel(){


    Panel colorMapEditor = new Panel();colorMapEditor.setLayout(layout);

    colorMapColorEditor  = new ColorEditor(pigment.color_map.getCurrentColor());
    colorMapPanel = new ColorMapPanel(pigment.color_map,colorMapColorEditor);

    WindowUtils.constrain(colorMapEditor,colorMapPanel,0,0,1,1,
			  GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,0.5,0.5);
    WindowUtils.constrain(colorMapEditor,colorMapColorEditor,0,1,1,1,
			  GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.);

    colorPanel = new Panel();
    CardLayout cardLayout = new CardLayout();
    colorPanel.setLayout(cardLayout);
    colorPanel.add("Color",colorEditor);
    colorPanel.add("ColorMap",colorMapEditor);

    return colorPanel;
  }

  public void placeEditControl(Container where, Component what, int x, int y){
    WindowUtils.constrain(where,what,x,y,1,1,GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);    
  }

  public void init(POVDeclare declare){
    init((POVPigment)declare.o);
    Frame f = WindowUtils.getMainWindow(this);
    if(f != null){
      f.setTitle("Pigment: "+declare.name);
      f.show();
    }
  }

  public void addNotify(){
    super.addNotify();
    initPanels();
  }
  
  void initPanels(){
    if(type.value.current.equals("color")){
      pDir.disable();
      pTurb.disable();
      pProp.disable();
      ((CardLayout)colorPanel.getLayout()).show(colorPanel,"Color");
      panelPigment.renameItem(2,"Color");
    } else if(type.value.current.equals("gradient")){
      pDir.enable();
      pTurb.enable();
      pProp.enable();      
      ((CardLayout)colorPanel.getLayout()).show(colorPanel,"ColorMap");
      panelPigment.renameItem(2,"ColorMap");
    } else {
      pDir.disable();
      pTurb.enable();
      pProp.enable();
      ((CardLayout)colorPanel.getLayout()).show(colorPanel,"ColorMap");
      panelPigment.renameItem(2,"ColorMap");
    }
  }
  
  void init(POVPigment pigment){
    this.pigment = pigment;
    octaves.setValue(pigment.octaves);
    omega.setValue(pigment.omega);
    lambda.setValue(pigment.lambda);
    frequency.setValue(pigment.frequency);
    phase.setValue(pigment.phase);
    agate_turb.setValue(pigment.agate_turb);
    for(int i=0;i<3;i++){
      scale[i].setValue(pigment.scale[i]);
      rotate[i].setValue(pigment.rotate[i]);
      translate[i].setValue(pigment.translate[i]);
      direction[i].setValue(pigment.direction[i]);
      turbulence[i].setValue(pigment.turbulence[i]);
      type.setValue(pigment.type);
    }

    colorMapPanel.init(pigment.color_map);
    colorEditor.init(pigment.color); 
    initPanels();
  }

  public boolean action(Event e, Object what){   
    
    if(e.target == type.choice){
      initPanels();
      return true;
    }
    return false;
  }    
}

