package PVS.POVTextureEditor;
// POVTexture.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
import java.awt.*;
import java.util.*;
import java.io.*;


class POVTextureLayer extends Object implements Drawable{
  POVPigment pigment;
  POVNormal normal;
  POVFinish finish;

  public POVTextureLayer(){   
    pigment = new POVPigment();
    normal = new POVNormal();
    finish = new POVFinish();
  }

  public POVTextureLayer(POVPigment pigment,POVNormal normal,POVFinish finish){   
    this.pigment = pigment;
    this.normal = normal;
    this.finish = finish;
  }

  public String toString(){
    return "texture {\n" +  pigment + 
      "\n" + normal + "\n" + finish + "\n}";
  }  

  public void draw(Graphics g, int width, int height){
    g.setColor(Color.blue);
    g.fillRect(0,0,width,height);
    g.setColor(Color.black);
    g.drawLine(0,0,width,height);
    g.drawLine(0,height,width,0);
  }

  public Object clone(){
    return  new POVTextureLayer((POVPigment)pigment.clone(), 
				(POVNormal)normal.clone(), 
				(POVFinish)finish.clone());    
  }
}
