package PVS.POVTextureEditor;
// POVTexture.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.util.Vector;
import PVS.Utils.DoubleR;

public class POVTexture extends POVThumbnailObject{
  public Vector layers = new Vector();
  public DoubleR[] translate_ = new DoubleR[3];

  static String texturepov = "texture.pov";
  static String textureinc = "texture.inc";

  public POVTexture() {
    // assign correct names for rendering
    povFile = texturepov;
    incFile = textureinc;

    for(int i=0;i<3;i++)
      translate_[i] = new DoubleR(0.0);
  }
    
  public String toString(){
    StringBuffer buf = new StringBuffer();
    for(int i=0;i<layers.size();i++){
      if(i>0) // new line for new texture
	buf.append("\n");
      buf.append(layers.elementAt(i).toString());
    }    
    return new String(buf);
  }
  

  public void scale(DoubleR s[]){
    
  }

  public void rotate(DoubleR s[]){

  }

  public void translate(DoubleR s[]){    
    for(int i=0;i<3;i++){ 
      translate_[i].value = s[i].value;
    }
  }

  public void addLayer(POVTextureLayer layer){
    layers.addElement(layer);
  }

  public POVTextureLayer lastLayer(){
    try {
      return (POVTextureLayer)(layers.lastElement());
    } catch (Exception e){} //NoSuchElementException, but there should be !!
    return null;
  }

  public Object clone(){
    POVTexture tex = new POVTexture();
    tex.assign(this);
    return tex;
  }

  public void assign(POVTexture tex){
    if(tex == this)
      return;
    layers.removeAllElements();
    for(int i=0; i < tex.layers.size(); i++){
      addLayer((POVTextureLayer)((POVTextureLayer)tex.layers.elementAt(i)).
	       clone());
    }
    thumbnailImage = tex.thumbnailImage;
    fullFileName = tex.fullFileName;
    isModified = true;
  }
}
