package PVS.POVTextureEditor;
import java.io.*;

/**
 * A class to turn an input POV ray commands stream into a stream of tokens.
 * @version 1.0, 09 May 1996
 * @author  Vladimir Bulatov
 */
class POVStreamTokenizer extends StreamTokenizer
{
  public POVStreamTokenizer(InputStream i){
    super(i);
    resetSyntax();
    wordChars('a', 'z');
    wordChars('A', 'Z');
    wordChars(128 + 32, 255);
    wordChars('_','_');
    wordChars('#','#');
    whitespaceChars(0, ' ');
    quoteChar('"');
    quoteChar('\'');
    parseNumbers();
    slashStarComments(true);
    slashSlashComments(true);
  }
}
