package PVS.POVTextureEditor;
import java.util.*;
import java.io.*;


public class POVRenderingQueue {

  static Stack queue = new Stack(); // stack of jobs

  static ProcessThread process = null; 
  static POVProcess currentJob = null;

  static {
    process = new ProcessThread();
    process.start();
  }
  
  /**
    submit job for queue
    observer - who to notify, when job is ready
    command - system command to run
    filename - file to write fileContents to for this command
    
    new submitted job is pushed on queue stack and will be rendered next
    but doesn't interrupt currently running process if there is one
    */
  static void submit(Observer observer, String[] command, String fileName,
		     String fileContents){
    POVProcess proc = new POVProcess(observer,command,fileName,fileContents);
    queue.push(proc);
    //System.out.println("submitted: " + command[0]+" "+command[1]+" "+command[2]+" ");
  }
  
  static void processFinished(String[] command){
    //System.out.println("finished: " + command[0]+" "+command[1]+" "+command[2]+" ");    
    currentJob.observer.update(null,null);
    process = null;
  }
}


class POVProcess extends Object{
  Observer observer;
  String[] command;
  String fileName;
  String fileContents;

  public POVProcess(Observer observer, String[] command, 
		    String fileName,String fileContents){
    this.observer = observer;
    this.command = command;
    this.fileName = fileName;
    this.fileContents  = fileContents;
  }
}

class ProcessThread extends Thread {

  Process process;

  public ProcessThread(){
  }       

  public synchronized void start(){
    //System.out.println("started: " + command);
    setPriority(MIN_PRIORITY);    
    process = null;
    super.start();
  }
  
  public void run(){

    while(true){
      //
      // wait for another job in queue
      //
      while(POVRenderingQueue.queue.empty()){
	try { sleep(100); } catch(Exception e){}
      }
      POVProcess proc = POVRenderingQueue.currentJob = 
	(POVProcess)POVRenderingQueue.queue.pop();
      File f = new File(proc.command[0]);
      if(f.exists()){
	try {
	  new DataOutputStream(new FileOutputStream(proc.fileName)).
	    writeBytes(proc.fileContents);      
	  process = Runtime.getRuntime().exec(proc.command);    
	  //System.out.println("running: " + proc.command[0]+" "+proc.command[1]+
	  //		     " "+proc.command[2]+" ");
	} catch(IOException e){
	  e.printStackTrace(System.out);
	}
	try{
	  process.waitFor();
	} catch (Exception e){
	  System.out.println("iterrupted: " + proc.command); // somebody interrupted us
	  System.out.println("Exception: " + e); 
	  process.destroy();
	}
	POVRenderingQueue.processFinished(proc.command);      
      } else {
	System.out.println("unable to locate \""+ proc.command[0]+
			   "\",  check file|properties...");
      }
      
    }    
  }
}

