package PVS.POVTextureEditor;
// POVPigment.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.util.Observer;
import java.util.Observable;
import PVS.Utils.*;

public class POVPigment extends POVThumbnailObject{

  static String[] pigmentNames = {
    "color","gradient", "granite", "marble", "onion",
    "bozo", "spotted", "wood", "agate", "leopard","wrinkles", "crackle"};

  public ChoiceR type = new ChoiceR(pigmentNames,pigmentNames[0]);
  public POVColor color = new POVColor();
  public POVColorMap color_map = new POVColorMap();
  public DoubleR octaves = new DoubleR(6.);
  public DoubleR   omega = new DoubleR(0.5);
  public DoubleR   lambda = new DoubleR(2.);
  public DoubleR   frequency = new DoubleR(1.);
  public DoubleR   phase = new DoubleR(0.);
  public DoubleR   agate_turb = new DoubleR(0.);
  public POVColor quick_color = new POVColor();
  public DoubleR[] turbulence = new DoubleR[3];
  public DoubleR[] direction = new DoubleR[3];
  public DoubleR[] scale = new DoubleR[3];
  public DoubleR[] rotate = new DoubleR[3];
  public DoubleR[] translate = new DoubleR[3];;

  
  static String pigmentpov = "pigment.pov";
  static String pigmentinc = "pigment.inc";

  public POVPigment(){
    // assign correct names for rendering thumbnails
    povFile = pigmentpov;
    incFile = pigmentinc;

    initVectors();
  }

  public void initVectors(){
    for(int i=0;i<3;i++){
      direction[i] = new DoubleR(0.);
      scale[i] = new DoubleR(1.);
      rotate[i] = new DoubleR(0.);
      turbulence[i] = new DoubleR(0.);
      translate[i] = new DoubleR(0.);
    }
    direction[0].value = 1;
  }

  public String toString(){
    if(type.current.equals("color"))
      return "pigment {"+ color +"}";
    else {
      StringBuffer buf = new StringBuffer("pigment {\n");
      buf.append(type.current);
      if(type.current.equals("gradient")){
	buf.append(" <"+direction[0].value+","+ direction[1].value+","+ 
		   direction[2].value+">");	
      } else if(type.current.equals("agate")){
	if(agate_turb.value != 0.)
	  buf.append("\n agate_turb " + agate_turb.value);
      }
      buf.append("\n"+color_map);
      if(turbulence[0].value != 0. || turbulence[1].value != 0. || 
	 turbulence[2].value != 0.){
	buf.append("\nturbulence <" + turbulence[0].value + "," 
		   + turbulence[1].value+","+turbulence[2].value+">");	  
	buf.append("\noctaves " + octaves.value + " omega " + omega.value);
	buf.append(" lambda " + lambda.value);
      }
      if(frequency.value != 1.0)
	buf.append("\n frequency " + frequency.value);
      if(phase.value != 0.0)
	buf.append("\nphase " + phase.value);
      if(scale[0].value != 1.0 || scale[1].value != 1.0 || 
	 scale[2].value != 1.0)
	buf.append("\nscale <"+scale[0].value+","+scale[1].value+","+ 
		   scale[2].value+">");
      if(rotate[0].value != 0.0 || rotate[1].value != 0.0 || 
	 rotate[2].value != 0.0)
	buf.append("\nrotate <"+rotate[0].value+","+rotate[1].value+","+ 
		   rotate[2].value+">");
      if(translate[0].value != 0.0 || translate[1].value != 0.0 || 
	 translate[2].value != 0.0)
	buf.append("\ntranslate <"+translate[0].value+","+
		   translate[1].value+","+ +translate[2].value+">");
      buf.append("\n}");
      return new String(buf);
    }
  }

  public Object clone(){
    
    POVPigment p = new POVPigment();
    p.assign(this);
    return p;
  }

  public void assign(POVPigment p){
    type.current = p.type.current;
    color = new POVColor(p.color);
    color_map = new POVColorMap(p.color_map);
    octaves.value = p.octaves.value;
    omega.value = p.omega.value;
    lambda.value = p.lambda.value;
    frequency.value = p.frequency.value;
    phase.value = p.phase.value;
    agate_turb.value = p.agate_turb.value;

    quick_color = new POVColor(p.quick_color);
    for(int i=0;i<3;i++){
      turbulence[i].value = p.turbulence[i].value;
      direction[i].value = p.direction[i].value;
      scale[i].value = p.scale[i].value;
      rotate[i].value = p.rotate[i].value;
      translate[i].value = p.translate[i].value;
    }
    thumbnailImage = p.thumbnailImage;    
    fullFileName = p.fullFileName;
    isModified = true;
  }

}
