package PVS.POVTextureEditor;
// POVFinish.java - a POVray  Texture editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
  
import java.io.*;

import PVS.Utils.*;

public class POVFinish extends Object implements Cloneable{

  static POVFinish def = new POVFinish();

  //POVColor ambient = new POVColor(0.1,0.1,0.1,0.1);
  DoubleR ambient = new DoubleR(0.1);
  DoubleR diffuse  = new DoubleR(0.6);
  DoubleR brilliance  = new DoubleR(1.0);
  DoubleR phong = new DoubleR(0.0);
  DoubleR phong_size = new DoubleR(40.);
  DoubleR specular  = new DoubleR(0.05);
  DoubleR roughness  = new DoubleR(0.0);
  DoubleR metallic  = new DoubleR(1.0);
  //POVColor reflection = new POVColor(0,0,0,0);
  DoubleR reflection = new DoubleR(0.0);
  DoubleR refraction = new DoubleR(0.0);
  DoubleR ior = new DoubleR(1.0);
  DoubleR caustics = new DoubleR(1.0);
  DoubleR fade_distance = new DoubleR(1.0);
  DoubleR fade_power  = new DoubleR(1.0);
  //[ irid { thickness FLOAT turbulence VECTOR } ]
  DoubleR crand = new DoubleR(0.);
  
  POVFinish() {
  }

  POVFinish(POVStreamTokenizer tokenizer) throws IOException {
    POVParse.expect(tokenizer,"finish");
    POVParse.expect(tokenizer,'{');
    while(true){
      if(tokenizer.nextToken() == '}')
	return;
      if(tokenizer.ttype == StreamTokenizer.TT_WORD){
	POVFinish fin;
	if((fin = POVParse.findFinish(tokenizer.sval)) != null){
	  this.assign(fin);
	} else if(tokenizer.sval.equals("ambient")){
	  //ambient = POVParse.getColor(tokenizer);
	  ambient = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("diffuse")){
	  diffuse = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("brilliance")){
	  brilliance = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("phong")){
	  phong = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("phong_size")){
	  phong_size = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("specular")){
	  specular = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("roughness")){
	  roughness = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("specular")){
	  specular = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("metallic")){
	  metallic = new DoubleR(1.0);//POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("reflection")){
	  //reflection = POVParse.getColor(tokenizer);
	  reflection = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("refraction")){
	  refraction = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("ior")){
	  ior = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("caustics")){
	  caustics = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("fade_distance")){
	  fade_distance = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("fade_power")){
	  fade_power = POVParse.getNumber(tokenizer).value;
	} else if(tokenizer.sval.equals("crand")){
	  crand = POVParse.getNumber(tokenizer).value;
	} else {
	  POVParse.exception(tokenizer,"illegal keyword");
	}
      } else {
	POVParse.exception(tokenizer,"illegal symbol");
      }              
    }
  }
  
  public void assign(POVFinish fin){
    ambient.value = fin.ambient.value;
    diffuse.value = fin.diffuse.value;
    brilliance.value = fin.brilliance.value;
    phong.value = fin.phong.value;
    phong_size.value = fin.phong_size.value;
    specular.value = fin.specular.value;
    roughness.value = fin.roughness.value;
    metallic.value = fin.metallic.value;
    reflection.value = fin.reflection.value;
    refraction.value = fin.refraction.value;
    ior.value = fin.ior.value;
    caustics.value = fin.caustics.value;
    fade_distance.value = fin.fade_distance.value;
    fade_power.value = fin.fade_power.value;
    crand.value = fin.crand.value;
    
  }
  
  public String toString(){
    StringBuffer buf = new StringBuffer("finish {\n");
    if(ambient.value!=def.ambient.value)
      buf.append(" ambient " + ambient);
    if(diffuse.value!=def.diffuse.value)
      buf.append(" diffuse "+diffuse);
    if(brilliance.value!=def.brilliance.value)
      buf.append(" brilliance "+brilliance);
    if(phong.value != def.phong.value)
      buf.append(" phong "+phong);
    if(phong_size.value != def.phong_size.value)
      buf.append(" phong_size "+phong_size);
    if(specular.value != def.specular.value)
      buf.append(" specular "+specular);
    if(reflection.value != def.reflection.value)
      buf.append(" reflection "+reflection);
    if(refraction.value != def.refraction.value)
      buf.append(" refraction "+refraction);
    if(ior.value != def.ior.value )
      buf.append(" ior " + ior);
    
    buf.append("\n}");      

    return new String(buf);   
    //    return "finish {"+
    //" roughness "+roughness+
    //" metallic "+metallic+
    //" caustics "+caustics+
    //  "fade_distance "+fade_distance+
    //	"fade_power "+fade_power+
    //	  "crand "+crand +
  }

  public Object clone(){
    POVFinish f = new POVFinish();
    f.ambient.value = ambient.value;
    f.diffuse.value = diffuse.value;
    f.brilliance.value = brilliance.value;
    f.phong.value = phong.value;
    f.phong_size.value = phong_size.value;
    f.specular.value = specular.value;
    f.roughness.value = roughness.value;
    f.metallic.value = metallic.value;
    f.reflection.value = reflection.value;
    f.refraction.value = refraction.value;
    f.ior.value = ior.value;
    f.caustics.value = caustics.value;
    f.fade_distance.value = fade_distance.value;
    f.fade_power.value = fade_power.value;
    f.crand.value = crand.value;
    return f;
  }
}
