package PVS.POVTextureEditor;
import java.awt.Graphics;
import java.awt.FontMetrics;
import java.awt.Color;
import java.io.File;


class POVDeclare extends POVObject implements Drawable{
  String name;
  Object o;

  public POVDeclare(String name, Object o){
    this.name = name;
    this.o = o;
    this.where = null;
  }

  public POVDeclare(String name, Object o,File where){
    this.name = name;
    this.o = o;
    this.where = where;
  }


  public String toString(){
    return "#declare "+ name + "=" + o; 
  }

  public void rename(String newName){
    name = newName;
    if( o instanceof POVTexture){
      ((POVTexture)o).rename(newName);
    } else if(o instanceof POVPigment){
      ((POVPigment)o).rename(newName);
    }
  }

  public void draw(Graphics g,int width, int height){
    FontMetrics fm = g.getFontMetrics();
    int h = fm.getHeight()+fm.getMaxDecent();
    if( o instanceof Drawable){
      ((Drawable)o).draw(g,width,height - h);
    } else {
      g.setColor(Color.white);
      g.fillRect(0,0,width,height-h);      
      g.setColor(Color.black);
      g.drawRect(0,0,width,height-h);      
      g.drawLine(0,0,width,height-h);
      g.drawLine(0,height-h,width,0);
    }
    int w = fm.stringWidth(name);
    g.setColor(Color.white);
    g.fillRect(0,height-h,width,h);
    g.setColor(Color.black);
    g.drawString(name,(width -w)/2,height - fm.getMaxDecent());
  }
  
}
