package PVS.POVTextureEditor;
import java.awt.*;
import java.awt.image.*;


public class POVColor extends ColorExt implements Drawable{

  public POVColor(double r, double g, double b, double t){
    super(r,g,b,t);
  }

  public POVColor(){
    super();
  }

  public POVColor(POVColor c){
    super(c);
  }

  public POVColor(ColorExt c){
    super(c);
  }


  //Image image = null;
  public void draw(Graphics g,int width, int height){
    Image image = null;
    if(image == null){
      int bytes[] = {this.getRGB()};
      if(ImageTGA.doGamma)
	ImageTGA.GammaImage(bytes);
      ImageProducer ip = new MemoryImageSource(1,1,bytes,0,1);
      image = Toolkit.getDefaultToolkit().createImage(ip);
    }
    g.drawImage(image, 0,0,width,height,null);
  }
  
  public Color getColor(){
    return new Color((float)r,(float)g,(float)b);
  }
  
  public Object clone(){
    return new POVColor(this);
  }
  
}

