package PVS.POVTextureEditor;
// NormalEditor.java - a Java colors map panel
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//             All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.awt.*;

import PVS.Utils.*;


class NormalEditor extends Panel {

  POVNormal normal;  

  DoubleField octaves,omega,lambda,strength,frequency,phase;
  DoubleField[] scale = new DoubleField[3];
  DoubleField[] rotate = new DoubleField[3];
  DoubleField[] translate = new DoubleField[3];

  DoubleField[] turbulence = new DoubleField[3];
  ChoiceField   type;

  Panel pTurb,pProp;
  GridBagLayout layout = new GridBagLayout();
  
  NormalEditor(POVNormal normal){
    this.normal = normal;
    this.setLayout(new GridBagLayout());

    TabbedPanel panelNormal = new TabbedPanel(this);
    panelNormal.addItem("Params",createParamsPanel());
    panelNormal.addItem("Transform",createTransformPanel());
    
    WindowUtils.constrain(this,panelNormal,0,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);    
  }  

  Component createParamsPanel(){
    Panel pAll = new Panel(); pAll.setLayout(layout);

    type = new ChoiceField("Type",normal.type);
    
    Panel pType = new BorderPanel(); pType.setLayout(layout);    
    WindowUtils.constrain(pType,type,0,0,1,1,GridBagConstraints.NONE,
                          GridBagConstraints.CENTER,1.0,1.0);
    
    pTurb = new BorderPanel(); pTurb.setLayout(layout);    
    WindowUtils.constrain(pTurb,new Label("Turbulence"),0,0,2,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,1.0,0.0);
    for(int i=0;i<3;i++){
      placeEditControl(pTurb,turbulence[i] =  
		       new DoubleField(String.valueOf((char)('X'+i)),
				       normal.turbulence[i],layout),0,i+1);
    }
    placeEditControl(pTurb,octaves = 
		     new DoubleField("octaves",normal.octaves,layout),1,1);
    placeEditControl(pTurb,omega = 
		     new DoubleField("omega",normal.omega,layout),1,2);
    placeEditControl(pTurb,lambda = 
		     new DoubleField("lambda",normal.lambda,layout),1,3);

    pProp = new BorderPanel(); pProp.setLayout(layout);    
    placeEditControl(pProp,strength = 
		     new DoubleField("strength",normal.frequency,layout),0,0);
    placeEditControl(pProp,frequency = 
		     new DoubleField("frequency",normal.frequency,layout),0,1);
    placeEditControl(pProp,phase = 
		     new DoubleField("phase",normal.phase,layout),0,2);
    
    Panel pProp2 = new Panel(); pProp2.setLayout(layout);

    WindowUtils.constrain(pAll,pType,0,0,1,1, 
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pTurb,0,1,1,1, 
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pProp,1,0,1,2, 
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    return pAll;

  }

  Component createTransformPanel(){

    Panel pAll = new Panel(); pAll.setLayout(layout);

    Panel pScale = new BorderPanel(); pScale.setLayout(layout);    
    Panel pRotate = new BorderPanel(); pRotate.setLayout(layout);    
    Panel pTranslate = new BorderPanel(); pTranslate.setLayout(layout);    

    WindowUtils.constrain(pScale,new Label("Scale"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,1.0,0.0);
    WindowUtils.constrain(pRotate,new Label("Rotate"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,1.0,0.0);
    WindowUtils.constrain(pTranslate,new Label("Translate"),0,0,1,1,
			  GridBagConstraints.NONE, GridBagConstraints.CENTER,1.0,0.0);
    
    for(int i=0;i<3;i++){
      WindowUtils.constrain(pScale,scale[i] = 
			    new DoubleField(String.valueOf((char)('X'+i)),
					    normal.scale[i],layout),0,i+1, 1,1, 
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,1.,1.);

      WindowUtils.constrain(pRotate,rotate[i] = 
			    new DoubleField(String.valueOf((char)('X'+i)),
					    normal.rotate[i],layout),0,i+1, 1,1, 
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,1.,1.);
      WindowUtils.constrain(pTranslate,translate[i] = 
			    new DoubleField(String.valueOf((char)('X'+i)),
					    normal.translate[i],layout),0,i+1, 1,1, 
			    GridBagConstraints.NONE, GridBagConstraints.CENTER,1.,1.);
    }

    WindowUtils.constrain(pAll,pScale,0,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pRotate,1,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    WindowUtils.constrain(pAll,pTranslate,2,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.EAST,1.,1.);
    return pAll;
  }

  public void placeEditControl(Container where, Component what, int x, int y){
    WindowUtils.constrain(where,what,x,y,1,1,GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);    
  }
  
  public void addNotify(){
    super.addNotify();
    initPanels();
  }

  void initPanels(){
    if(type.value.current.equals("none")){
      pTurb.disable();
      pProp.disable();
    } else {
      pTurb.enable();
      pProp.enable();
    }
  }

  public boolean action(Event e, Object what){   
    if(e.target == type.choice){
      initPanels();
      return true;
    }
    return false;
  }    

  void init(POVNormal normal){
    this.normal = normal;
    strength.setValue(normal.strength);
    octaves.setValue(normal.octaves);
    omega.setValue(normal.omega);
    lambda.setValue(normal.lambda);
    frequency.setValue(normal.frequency);
    phase.setValue(normal.phase);
    for(int i=0;i<3;i++){
      scale[i].setValue(normal.scale[i]);
      rotate[i].setValue(normal.rotate[i]);
      translate[i].setValue(normal.translate[i]);
      turbulence[i].setValue(normal.turbulence[i]);
      type.setValue(normal.type);
    }

    initPanels();
  }

}
