package PVS.POVTextureEditor;

import java.awt.*;
import java.awt.image.*;
import java.io.*;


public class ImageTGA {

  static final int ALPHA = 0xff000000; 
  static public Image read(InputStream inp) throws IOException{

    byte [] header = new byte[18];
    inp.read(header);
    /*
    for(int i=0;i<18;i++)
      System.out.println((int)header[i]);
      */ 
    // doesn't works if width >=128 (byte - signed integer)
    int width =  ((header[12]&0xff)) | ((header[13]&0xff) << 8);
    int height = ((header[14]&0xff)) | ((header[15]&0xff) << 8);
    
    // blue, gree, red bytes

    int length = width*height;
    int[] buffer = new int[length];
    byte[] bbuf = new byte[3*length];
    inp.read(bbuf);
    
    if(doGamma)
      GammaImage(bbuf,buffer);
    else { 
      for(int i=0,k=0;i<length;i++){
	buffer[i] = (bbuf[k++]&0xff) | ((bbuf[k++]&0xff)<<8) | 
	  ((bbuf[k++]&0xff)<<16) | ALPHA;
      }
    }
    ImageProducer ip = new MemoryImageSource(width,height,buffer,0,width);
    Image image = Toolkit.getDefaultToolkit().createImage(ip);

    return image;
  }
  
  static boolean doGamma = true;
  static int[] gamma_map_r,gamma_map_g, gamma_map_b;
  static int[] un_gamma_map_r,un_gamma_map_g, un_gamma_map_b;
  static double red_gamma = 2.2, green_gamma = 2.2, blue_gamma = 2.2;
  static int MaxRGB = 255;
  static {
    gamma_map_r = new int[MaxRGB+1];
    gamma_map_g = new int[MaxRGB+1];
    gamma_map_b = new int[MaxRGB+1];
    un_gamma_map_r = new int[MaxRGB+1];
    un_gamma_map_g = new int[MaxRGB+1];
    un_gamma_map_b = new int[MaxRGB+1];
    
    if (red_gamma != 0.0)
      for(int i=0; i<=MaxRGB; i++){
	gamma_map_r[i]= (int)((Math.pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)-0.5);
	un_gamma_map_r[i]= (int)((Math.pow((double) i/MaxRGB,red_gamma)*MaxRGB)-0.5);
	//System.out.println(gamma_map_r[i]);
      }
    if (green_gamma != 0.0)
      for(int i=0; i<=MaxRGB; i++){
	gamma_map_g[i]=(int)((Math.pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);
	un_gamma_map_g[i]=(int)((Math.pow((double) i/MaxRGB,green_gamma)*MaxRGB)+0.5);
      }
    if (blue_gamma != 0.0)
      for(int i=0; i<=MaxRGB; i++){
	gamma_map_b[i]=(int)((Math.pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);    
	un_gamma_map_b[i]=(int)((Math.pow((double) i/MaxRGB,blue_gamma)*MaxRGB)+0.5);    
      }
  }

  static void GammaImage(byte[] buf){
    for (int i=0; i < buf.length; ) {
      buf[i] = (byte)gamma_map_b[(buf[i]&0xff)]; i++;
      buf[i] = (byte)gamma_map_g[(buf[i]&0xff)]; i++;
      buf[i] = (byte)gamma_map_r[(buf[i]&0xff)]; i++;
    }    
  }

  static void GammaImage(byte[] buf,int[] ibuf){
    for (int k=0,i=0; i < ibuf.length;i++ ) {
      ibuf[i] = gamma_map_b[(buf[k++]&0xff)] | (gamma_map_g[(buf[k++]&0xff)]<<8) | 
	(gamma_map_r[(buf[k++]&0xff)]<<16) | ALPHA;
    }    
  }

  static void GammaImage(int[] ibuf){
    for (int i=0; i < ibuf.length;i++ ) {
      int c = ibuf[i];
      ibuf[i] = gamma_map_b[(c&0xff)] | (gamma_map_g[(c>>8)&0xff]<<8) | 
	(gamma_map_r[(c>>16)&0xff]<<16) | ( c&ALPHA );
    }    
  }

  static void GammaImage(int[] ibuf,int offset, int length){
    for (int i=offset; i < offset+length;i++ ) {
      int c = ibuf[i];
      ibuf[i] = gamma_map_b[(c&0xff)] | (gamma_map_g[(c>>8)&0xff]<<8) | 
	(gamma_map_r[(c>>16)&0xff]<<16) | ( c&ALPHA );
    }    
  }
  static void UnGammaImage(int[] ibuf){
    for (int i=0; i < ibuf.length;i++ ) {
      int c = ibuf[i];
      ibuf[i] = un_gamma_map_b[(c&0xff)] | (un_gamma_map_g[(c>>8)&0xff]<<8) | 
	(un_gamma_map_r[(c>>16)&0xff]<<16) | ( c&ALPHA );
    }    
  }

  static public void write(Image img, OutputStream out) throws IOException{
    //System.out.println("image:"+img);
    //System.out.println("producer:"+img.getSource());
    int width = img.getWidth(null),height = img.getHeight(null);
    int len = width*height;
    int[] pixels = new int[len];
    PixelGrabber pg = new PixelGrabber(img,0,0,width,height,pixels,0,width);
    System.out.println("grabbing ["+width+","+height+"]");System.out.flush();
    try{
      // it looks like it should be nonzero time here
      pg.grabPixels(1000); 
    }catch(InterruptedException e){
      System.err.println("interrupted waiting for pixels!");
      return;
    }    
    System.out.println("ready...");System.out.flush();
    if ((pg.status() & ImageObserver.ABORT) != 0) {
      System.err.println("image fetch aborted or errored");
      return;
    }
    for (int i = 0; i < 10; i++){    // 00, 00, 02, then 7 00's...
      if (i == 2)
	out.write(i);
      else
	out.write(0);
    }      
    out.write(0); // y origin set to "First_Line" 
    out.write(0);
    
    out.write(width % 256);  out.write(width / 256); // write width and height     
    out.write(height % 256); out.write(height / 256);
    out.write(24);  // 24 bits/pixel (16 million colors!) 
    out.write(32);  // Bitmask, pertinent bit: top-down raster 

    if(doGamma)  // convert image back
      UnGammaImage(pixels);
    
    for(int i = 0;i<len;i++) {
      int p = pixels[i];
      out.write(p&0xff); 
      out.write((p>>8)&0xff); 
      out.write((p>>16)&0xff); 
    }
  }

  static public void main(String[] args) throws FileNotFoundException,IOException{
    if(args.length ==0){
      System.out.println("usage: ImageTGA file.tga");
      System.exit(-1);
    }
    Image image = ImageTGA.read(new FileInputStream(args[0]));
    System.out.println("file: " + args[0] + "(" + image.getWidth(null) + 
		       "," + image.getHeight(null) + ")");
    System.exit(0);
  }
}





