package PVS.POVTextureEditor;
// FinishEditor.java - a POVray Texture Editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//             All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
import java.awt.*;

import PVS.Utils.*;


class FinishEditor extends Panel {

  POVFinish finish;  
  GridBagLayout layout = new GridBagLayout();

  DoubleField 
    ambient,diffuse, specular, 
  phong, phong_size,brilliance, 
  roughness, metallic, crand, 
  reflection, refraction, ior, 
  caustics, fade_distance, fade_power;

  public FinishEditor(POVFinish finish){
    this.finish = finish;
    this.setLayout(layout);
    Panel panelAll = new BorderPanel(); panelAll.setLayout(layout);
    Panel panel1 = new BorderPanel(); panel1.setLayout(layout);
    Panel panel2 = new BorderPanel(); panel2.setLayout(layout);
    Panel panel3 = new BorderPanel(); panel3.setLayout(layout);
    Panel panel4 = new BorderPanel(); panel4.setLayout(layout);

    placeEditControl(panel1,ambient =
		     new DoubleField("ambient",finish.ambient,layout),0,0);
    placeEditControl(panel1,diffuse = 
		     new DoubleField("diffuse",finish.diffuse,layout),0,1);
    placeEditControl(panel1,specular = 
		     new DoubleField("specular",finish.specular,layout),0,2);

    placeEditControl(panel2,phong = new DoubleField("phong",finish.phong,layout),0,0);
    placeEditControl(panel2,phong_size = 
		     new DoubleField("phong_size",finish.phong_size,layout),0,1);
    placeEditControl(panel2,brilliance = 
		     new DoubleField("brilliance",finish.brilliance,layout),0,2);


    placeEditControl(panel3,reflection = 
		     new DoubleField("reflection",finish.reflection,layout),0,0);
    placeEditControl(panel3,refraction = 
		     new DoubleField("refraction",finish.refraction,layout),0,1);
    placeEditControl(panel3,ior = 
		     new DoubleField("ior",finish.ior,layout),0,2);
    
    placeEditControl(panel4,caustics = 
		     new DoubleField("caustics",finish.caustics, layout),0,0);
    placeEditControl(panel4,fade_distance = 
		     new DoubleField("fade_distance", finish.fade_distance,layout),0,1);
    placeEditControl(panel4,fade_power = 
		     new DoubleField("fade_power",finish.fade_power,layout),0,2);
     
    WindowUtils.constrain(panelAll,panel1,0,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);    
    WindowUtils.constrain(panelAll,panel2,1,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);    
    WindowUtils.constrain(panelAll,panel3,0,1,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);
    WindowUtils.constrain(panelAll,panel4,1,1,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);

    WindowUtils.constrain(this,panelAll,0,0,1,1,
			  GridBagConstraints.BOTH, GridBagConstraints.CENTER,1.,1.);
  }  

  public void placeEditControl(Container where, Component what, int x, int y){
    WindowUtils.constrain(where,what,x,y,1,1,GridBagConstraints.NONE, 
			  GridBagConstraints.EAST,1.,1.);    
  }
   
  void init(POVFinish finish){

    this.finish = finish;

    ambient.setValue(finish.ambient);
    diffuse.setValue(finish.diffuse);
    specular.setValue(finish.specular);

    phong.setValue(finish.phong);
    phong_size.setValue(finish.phong_size);
    brilliance.setValue(finish.brilliance);


    reflection.setValue(finish.reflection);
    refraction.setValue(finish.refraction);
    ior.setValue(finish.ior);
    
    caustics.setValue(finish.caustics);
    fade_distance.setValue(finish.fade_distance);
    fade_power.setValue(finish.fade_power);
  }
}

