package PVS.POVTextureEditor;
// FilterCanvas.java - a Java colors map canvas
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//             All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.awt.*;
import java.io.*;

import PVS.Utils.*;

class FilterCanvas extends ColorMapCanvas {  

  DoubleField filterField;
  
  FilterCanvas(DoubleField filterField){
    super(new ColorMap());
    this.filterField = filterField;
    this.colorMap.addEntry(new ColorMapEntry(new ColorExt(0,0,0,0),
					     new ColorExt(1,1,1,0),0,1));        
  }
  
  public Dimension preferredSize(){
    return new Dimension(60,20);
  }

  public Dimension mimimumSize(){
    return new Dimension(20,10);
  }

  public boolean mouseUp(Event e, int x, int y) {
    double w = ((double)size().width-x)/(size().width);
    filterField.setValue(((int)(w*1000.+ 0.5))/1000.);
    repaint();
    filterField.postEvent(new Event(filterField,Event.ACTION_EVENT,null));
    return true;
  }    
  public void paint(Graphics g) {
    super.paint(g);
    g.setColor(Color.blue);
    int x = (int)((1-filterField.value.value)*(size().width-3));
    g.fillRect(x+1,0,3,size().height);
  }
}
