package PVS.POVTextureEditor;
// DrawableBrowser.java - a browser of set of DrawAble objects
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.


import java.awt.*;
import java.io.*;
import java.util.Vector;

import PVS.Utils.*;

public class DrawableBrowser extends Panel {
  
  GridBagLayout layout = new GridBagLayout();

  Scrollbar scrollbar = new Scrollbar(Scrollbar.VERTICAL);
  Panel panel = new BorderPanel();
  Drawable currentObject = null;

  int rows = 4;
  int columns = 4;
  int selectWidth = 2;
  Vector array;
  SamplePanel [] samplePanels;
  Component notifyParent = null;
  
  public DrawableBrowser() {
    
    this.setLayout(layout);
    panel.setLayout(new GridLayout(rows,columns,5,5));
    samplePanels = new SamplePanel[rows*columns];

    for(int i=0;i<rows*columns;i++){
      samplePanels[i] = new SamplePanel();
      samplePanels[i].unsetDrawable();
      panel.add(samplePanels[i]);
    }
    
    WindowUtils.constrain(this,panel,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.);
    WindowUtils.constrain(this,scrollbar,1,0,1,1,GridBagConstraints.VERTICAL,
                          GridBagConstraints.CENTER,0.,1.);    
  }
  
  public boolean action(Event e, Object what){   
    return false;
  }

  private long firstUp = 0;
  public boolean mouseUp(Event e, int x, int y) {
    if(e.when - firstUp < 1000){ // double click ?
      if(notifyParent != null && currentObject != null){
	notifyParent.postEvent(new Event(this,Event.ACTION_EVENT,
					 currentObject));
      }
    } else {
      firstUp = e.when; // for double click check      
    }
    return false;
  }

  public boolean handleEvent(Event e){   
    if(e.target == scrollbar){
      //System.out.println("Scroll: "+((Integer)e.arg).intValue());
      this.scroll(((Integer)e.arg).intValue());
    }
    switch(e.id){
    default:
      break;
    case Event.MOUSE_ENTER:
      if(e.target instanceof SamplePanel){
	Graphics g = panel.getGraphics();
	Rectangle r = (((SamplePanel)e.target).bounds());
	g.setColor(Color.blue);
	g.drawRect(r.x-selectWidth,r.y-selectWidth,
		   r.width+2*selectWidth,r.height+2*selectWidth);	
	currentObject = ((SamplePanel)e.target).drawable;
      }
      break;
    case Event.MOUSE_EXIT:
      if(e.target instanceof SamplePanel){
	Graphics g = panel.getGraphics();
	Rectangle r = (((SamplePanel)e.target).bounds());
	g.setColor(getBackground());
	g.drawRect(r.x-selectWidth,r.y-selectWidth,
		   r.width+2*selectWidth,r.height+2*selectWidth);
      }
      break;      
    }

     
    return super.handleEvent(e);
  }

  void scroll(int d){
    int start = d*columns;
    for(int i=0;i<rows*columns;i++){
      int k = start+i;
      if(k < array.size())
	samplePanels[i].setDrawable((Drawable)array.elementAt(k));
      else 
	samplePanels[i].unsetDrawable();
      samplePanels[i].repaint();
    }
  }

  public void init(Vector array,Component parent){

    this.array = array;
    this.notifyParent = parent;

    for(int i=0;i<rows*columns;i++){
      if(i < array.size())
	samplePanels[i].setDrawable((Drawable)array.elementAt(i));
    }
    scrollbar.setValues(0,1,0,(array.size()-rows*columns+columns-1)/columns);
    scrollbar.setPageIncrement(rows-1);
    scrollbar.setLineIncrement(1);
    
  } 

  public static void main(String[] args) throws IOException{
    int N = 42;
    Vector array = new Vector();
    for(int i=0;i<N;i++){
      array.addElement(new POVDeclare("color"+i, 
				      new POVColor(((double)i*255)/N,
						   ((double)i*255)/N,
						   ((double)i*255)/N,0)));
    }
    
    DrawableBrowser browser = new DrawableBrowser();
    Frame f = new DestroyableFrame("DrawableBrowser");
    f.add("Center",browser);
    f.pack();
    f.show();
    
    browser.init(array,f);
    f.pack();
    f.show();
  }
}
