package PVS.POVTextureEditor;
// Defaults.java - (main program of POVray Texture editor)
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//            All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.io.*;

class Defaults{
  static String texture = 
    "camera {location <0,0,-3.5> look_at <0,0,0> direction <0,0,1.5>\n"+
      " up <0,1,0> right <1,0,0>}\n"+ 
	"light_source {<1, 1, -5> color rgb <1,1,1>}\n"+
	  "sphere {<0,0,0>, 1 \n#include \"texture.inc\"\n}\n";
  static String pigment = 
    "camera {location <0,0,-3.5> look_at <0,0,0> direction <0,0,1.5>\n"+
      " up <0,1,0> right <1,0,0>}\n"+ 
	"light_source {<1, 1, -5> color rgb <1,1,1>}\n"+
	  "plane {<0,0,1>, 0 \n#include \"pigment.inc\"\n}\n";
  static String defs = "-w50 \n-h50 \n-A0.1 \n+Ft \n-V \n +B500\n";

  public static void  createDefaultFiles(){
    try{
      DataOutputStream out = 
	new DataOutputStream
	  ( new FileOutputStream(getPropertiesDir()+ 
				 File.separator+"texture.pov"));
      out.writeBytes(texture);
      out.close();
      out = new DataOutputStream
	( new FileOutputStream(getPropertiesDir()+ 
			       File.separator+"pigment.pov"));
      out.writeBytes(pigment);
      out.close();
      out = new DataOutputStream
	( new FileOutputStream(getPropertiesDir()+ 
			       File.separator+"povray.def"));
      out.writeBytes(defs);
      out.close();
    }catch(IOException e){
      System.err.println("unable to save default files to "+
			 getPropertiesDir());
      return;
    }
    System.out.println("default working files was successfully saved to "+
		       getPropertiesDir());    
  }

  static String getPropertiesDir(){
    return System.getProperty("user.home") + File.separator + 
      ".POVTextureEditor";
  }

   public static void CheckFile(String path) throws IOException {
     File f = new File(path);
     if(!f.exists())
       throw new IOException("File: \""+ path+ "\" not found");
   }
}
