package PVS.POVTextureEditor;
// ColorModel.java - a color model for color editing operations
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.


import java.util.Observable;

public class ColorModel extends Observable {
  public ColorExt color;
  static final int R = 0, G = 1, B = 2, H = 3, S = 4, L = 5;
  public int model = R;
  public int grid = 3;
  double[] hsl = new double[3];

  ColorModel(ColorExt color){
    this.color = color;
    makeHSL();
  }

  ColorModel(){
    this.color = new ColorExt();
  }
  ColorModel(ColorExt color,int model, int grid){
    this.color = color;
    this.model = model;
    this.grid = grid;
    makeHSL();
  }  

  void makeHSL(){
    ColorExt.RGBtoHSB(color.r,color.g,color.b,hsl);
  }

  void setEditingColor(ColorExt color){
    this.color = color;
    makeHSL();
  }

  void setColor(ColorExt color){
    this.color.r = color.r;
    this.color.g = color.g;
    this.color.b = color.b;
    this.color.f = color.f;
    makeHSL();
    setChanged();
    notifyObservers(color);
  }
}
