package PVS.POVTextureEditor;
import java.awt.*;

public class ColorMapEntry extends Object implements Cloneable{
  double t1, t2; // texture coordinates at ends (between 0.0 and 1.0)
  ColorExt c1, c2;  // colors at ends 
  double a1,a2;  // alphas at ends // (a == 0) - transparent (a == 1) - opaque 

  static final int NONE=0,LEFT=1,RIGHT=2,BOTH=3;
  static final double MINIMAL_WIDTH = 0.03;
  int active = NONE;

  ColorMapEntry(ColorExt c1, ColorExt c2, double t1, double t2, 
		double a1, double a2){
    this.c1 = new ColorExt(c1);
    this.c2 = new ColorExt(c2);
    this.t1 = t1;
    this.t2 = t2;
    this.a1 = a1;
    this.a2 = a2;
  }

  ColorMapEntry(ColorExt c1, ColorExt c2, double t1, double t2){
    this.c1 = new ColorExt(c1);
    this.c2 = new ColorExt(c2);
    this.t1 = t1;
    this.t2 = t2;
    this.a1 = 1.0-c1.f;
    this.a2 = 1.0-c2.f;
  }

  static final int ALPHA = 0xff000000;
  /**
    return interpolated value of colors at point t
   */
  int getPixel(double t){
    return (getColorExt(t).getRGB());   
  }

  int getAlpha(double t){
    double t21 = t2-t1;
    int a = (int)(255*(a2*(t-t1) + a1*(t2-t))/t21);
    return (ALPHA | a | (a<<8) | (a<<16));
  }

  ColorExt getColorExt(double t){
    double t21 = t2-t1,tt1= (t-t1)/t21,tt2 = (t2-t)/t21;
    return new ColorExt(c2.r*tt1+c1.r*tt2,c2.g*tt1+c1.g*tt2,
			c2.b*tt1+c1.b*tt2, c2.f*tt1+c1.f*tt2);
  }

  ColorExt getColorExt(){
    switch(active){
    case LEFT:
      return c1;
    case RIGHT:
      return c2;
    default:
    case NONE:
    case BOTH:
      return getColorExt((t1+t2)/2);
    }
  }

  ColorExt getFullColor(double t,ColorExt bg){
    ColorExt c = getColorExt(t);
    double att = (1.0 - c.f);
    c.r = bg.r*c.r*c.f + c.r*att;
    c.g = bg.g*c.g*c.f + c.g*att;
    c.b = bg.b*c.b*c.f + c.b*att;
    c.f = 0;
    return c;
  }

  ColorExt correct(ColorExt col, ColorExt col1, ColorExt col2){
    return new ColorExt(ClampColorComponent(col.r + col1.r - col2.r),
			ClampColorComponent(col.g + col1.g - col2.g),
			ClampColorComponent(col.b + col1.b - col2.b),
			ClampColorComponent(col.f + col1.f - col2.f));
  }
    
  static double ClampColorComponent(double c){
    return Math.min(1.,Math.max(0.,c));
  }

  void setColor(ColorExt color){
    switch(active){
    case  LEFT:
      c1 = color; break;
    case RIGHT:
      c2 = color; break;
    case BOTH:
      ColorExt cav = getColorExt((t1+t2)/2);
      //System.out.println("before:"+c1.toString()+"," +c2.toString()+","
      //			 + color.toString() +","+ cav.toString());
      c1 = correct(c1,color,cav); c2 = correct(c2,color,cav);
      //System.out.println("after:"+c1.toString()+"," +c2.toString());

      break;
    }

  }

  int getActive(){
    return active;
  }

  void setActive(){
    active = BOTH;
  }

  void setActive(int what){
    active = what;
  }

  double getPosition(){
    switch(active){
    default:
    case NONE:
    case BOTH:
      return (t1+t2)/2.0;
    case LEFT:
      return t1;
    case RIGHT:
      return t2;
    }
  }

  protected Object clone(){
    return new ColorMapEntry(c1, c2, t1, t2);
  }
}
