package PVS.POVTextureEditor;
// ColorMapEditor.java - a Java ColorMap editor
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.


import java.awt.*;

import PVS.Utils.*;


public class ColorMapEditor extends java.applet.Applet {

  ColorMap colorMap = null;
  
  GridBagLayout layout = new GridBagLayout();

  ColorEditor colorEditor; 
  ColorMapPanel colorMapPanel;
  Frame colorMapFrame;
  public void init() {

    this.setLayout(layout);

    colorMap = ColorMap.CreateRainbow(); 

    colorEditor  = new ColorEditor(colorMap.getCurrentColor());
    Panel pAll = new BorderPanel(BorderPanel.RAISED); pAll.setLayout(layout);
    WindowUtils.constrain(this,pAll,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);

    Panel pColorMapPanel = new BorderPanel(BorderPanel.RECESSED); pColorMapPanel.setLayout(layout);

    Panel pColorEditor = new BorderPanel(BorderPanel.RECESSED); pColorEditor.setLayout(layout);



    WindowUtils.constrain(pAll,pColorEditor,0,1,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);
    WindowUtils.constrain(pColorEditor,colorEditor,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);

    colorMapPanel = new ColorMapPanel(colorMap,colorEditor);
    WindowUtils.constrain(pColorMapPanel,colorMapPanel,0,0,1,1,GridBagConstraints.BOTH,
                          GridBagConstraints.CENTER,1.,1.,0,0,0,0);

    colorMapFrame = new Frame("ColorMap");
    colorMapFrame.add("Center",pColorMapPanel);
    colorMapFrame.pack();
  }
  
  public void start(){
    colorMapFrame.show();
  }

  public void stop(){
    colorMapFrame.hide();
  }

  public boolean action(Event e, Object what){   
    return true;
  }

  public String getAppletInfo() {
    return getClass().getName() + 
      " - Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov.ic.ac.uk>.  All rights reserved.";
  }

  public static void main(String[] args) {
    ColorMapEditor applet = new ColorMapEditor();
    applet.init();
    Frame frame = new AppletFrame("ColorMapEditor");
    frame.add("Center", applet);
    frame.resize(450, 450);
    frame.show();
    applet.start();
  }
}
