package PVS.POVTextureEditor;
// ColorMapCanvas.java - a Java colors map canvas
//
// Copyright (C) 1996 by Vladimir Bulatov <V.Bulatov@ic.ac.uk>.  
//             All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

import java.awt.*;
import java.io.*;

import PVS.Utils.*;

class ColorMapCanvas extends Canvas
{  

  ColorMap colorMap = null;
  boolean isValidImage = false;
  
  ColorMapCanvas(ColorMap colorMap){
    this.colorMap = colorMap;
  }

  void init(ColorMap c){
    colorMap = c;
    isValidImage = false;
    repaint();
  }
  
  public Dimension preferredSize(){
    return new Dimension(256,40);
  }

  public Dimension minimumSize(){
    return preferredSize();
  }

  private int Width = -1; // length of pixels strip
  int [] Pixels = null;      // pixel image of strip
  private Image stripImage=null;  
  

  void createStrip(){
    if(Pixels == null || Width != size().width){
      Pixels = null; // they will be reallocated in colorMap
      Width = size().width;
      stripImage = colorMap.createStrip(Width,Pixels);
    }
  }
  
  public void update(Graphics g){
    paint(g);
  }
  
  public void paint(Graphics g) {
    if(!isValidImage || Width != size().width){
      createStrip();
    }
    g.drawImage(stripImage,0,0,size().width,size().height, null);
  }  

  public boolean mouseExit(Event e, int x, int y)
    {
      (WindowUtils.getMainWindow(this)).setCursor(Frame.DEFAULT_CURSOR);
      return true;
    }    
  public boolean mouseEnter(Event e, int x, int y)
    {
      (WindowUtils.getMainWindow(this)).setCursor(Frame.HAND_CURSOR);
      return true;
    }    

  public boolean mouseUp(Event e, int x, int y)
    {      
      colorMap.setColor(this.getColor(x));
      repaint();
      return true;
    }    

  public ColorExt getColor(int position){
    return colorMap.getColor((double)position/size().width);
  }

}
