package PVS.POVTextureEditor;


import java.awt.Color;

public class ColorExt  extends Object  implements Cloneable{
  // color extension for using HSL - RGB translation

  public static final int H=0,S=1,L=2,R=0,G=1,B=2;

  // rgb[3] - red, green, blue
  // hsl[3] - hue, saturation, luminance
  public static void HSLtoRGB(double[] hsl, double[] rgb){
    
  }

  static final double SQRT6=2.44948974278317809819;
  static final double SQRT2=1.41421356237309504880;
  static final double SQRT12=3.46410161513775458705;


  public static void RGBtoHSL(double[] rgb, double[] hsl){
    // luminance
    hsl[L] = (rgb[R]+rgb[G]+rgb[B])/3;
    
    if(hsl[L] == 0.0){
      hsl[H] = 0.0; hsl[S] = 0.0; return;
    }
    hsl[H] = Math.atan2((rgb[G]-rgb[B])/SQRT2,
			(2*rgb[R]-rgb[G]-rgb[B])/SQRT6)/Math.PI;

    double[] r = {rgb[R]-hsl[L],rgb[G]-hsl[L],rgb[B]-hsl[L]};
    double[] r2 = {(r[0]*2-r[1]-r[2])/2, (r[1]-r[2])/SQRT2};    

    System.out.println("r2[0]:"+r2[0]);    
    System.out.println("r2[1]:"+r2[1]);    
  }

  public static void main(String[] args){
    if(args.length < 4){
      System.out.println("usage <HSL h s l> or <RGB r g b>");
      System.exit(-1);
    }
    double[] rgb = new double[3];
    double[] hsl = new double[3];
    if(args[0].equals("RGB")){
      rgb[0] = Double.valueOf(args[1]).doubleValue();
      rgb[1] = Double.valueOf(args[2]).doubleValue();
      rgb[2] = Double.valueOf(args[3]).doubleValue();
      ColorExt.RGBtoHSL(rgb,hsl);
    } else if(args[0].equals("HSL")){
      hsl[0] = Double.valueOf(args[1]).doubleValue();
      hsl[1] = Double.valueOf(args[2]).doubleValue();
      hsl[2] = Double.valueOf(args[3]).doubleValue();
      ColorExt.HSLtoRGB(hsl,rgb);
    }

    System.out.println("R:"+rgb[0]);
    System.out.println("G:"+rgb[1]);
    System.out.println("B:"+rgb[2]);
    System.out.println("H:"+hsl[0]);
    System.out.println("S:"+hsl[1]);
    System.out.println("L:"+hsl[2]);    
    
  }

  public static ColorExt black = new ColorExt(0,0,0,0);
  public static ColorExt white = new ColorExt(1,1,1,0);


  public double r,g,b,f; // current color values

  public ColorExt(double r, double g, double b, double f){
    this.r = r; this.g = g; this.b = b; this.f = f;
  }

  public ColorExt(double r, double g, double b){
    this.r = r; this.g = g; this.b = b; this.f = 0;
  }

  /**
    default constructor
   */
  public ColorExt(){ 
    r=0.0;
    g=0.0;
    b=0.0;
    f=0.0;
  }

  public ColorExt(ColorExt c){
    r = c.r;
    g = c.g;
    b = c.b;
    f = c.f;
  }

  public ColorExt(int rgb){
    r = (0xff & (rgb>>16))/255.;
    g = (0xff & (rgb>>8))/255.;
    b = (0xff & (rgb))/255.;
    f = 0.; // should it be so ?

  }
  public String toString(){
    return "color rgbf <"+r+","+g+","+b+","+f+">";
  }

  static final int ALPHA = 0xff000000;

  public int getRGB(){
    return ALPHA | (((int)(r*255))<<16) | (((int)(g*255))<<8) | ((int)(b*255));
  }

  public static int getRGB(int r,int g,int b){
    return ALPHA|(r<<16)|(g<<8)| b;
  }

  public ColorExt getFilteredColor(ColorExt c){
    double att = 1-f;
    return new ColorExt(c.r*r*f + r*att, c.g*g*f + g*att, c.b*b*f + b*att, 0);
  }
  
  public static int HSBtoRGB(double h, double s, double l){
    return ALPHA | Color.HSBtoRGB((float)h, (float)s, (float)l );
  }

  public static double[] RGBtoHSB(double r,double g,double b, double[] hsbvals){
    double hue, saturation, brightness;
    if (hsbvals == null) {
      hsbvals = new double[3];
    }
    double cmax = (r > g) ? r : g;
    if (b > cmax) cmax = b;
    double cmin = (r < g) ? r : g;
    if (b < cmin) cmin = b;
    
    brightness = cmax;
    if (cmax != 0.)
      saturation = (cmax - cmin) / cmax;
    else
      saturation = 0.;
    if (saturation == 0.)
      hue = 0.;
    else {
      double redc =   (cmax - r) / (cmax - cmin);
      double greenc = (cmax - g) / (cmax - cmin);
      double bluec =  (cmax - b) / (cmax - cmin);
      if (r == cmax)
	hue = bluec - greenc;
      else if (g == cmax)
	hue = 2.0 + redc - bluec;
      else
	hue = 4.0 + greenc - redc;
      hue = hue / 6.0;
      if (hue < 0)
	hue = hue + 1.0;
    }
    hsbvals[0] = hue;
    hsbvals[1] = saturation;
    hsbvals[2] = brightness;
    return hsbvals;    
  }

  public static ColorExt getHSBColor(double h, double s, double b){
    return getHSBColor(h,s,b,0.);
  }

  public static ColorExt getHSBColor(double hue, double saturation, 
				     double brightness, double filter){
    double r = 0, g = 0, b = 0;
    if (saturation == 0.) {
      r = g = b = (brightness);
    } else {
      double h = hue * 6.0;
      double f = h - java.lang.Math.floor(h);
      double p = brightness * (1.0 - saturation);
      double q = brightness * (1.0 - saturation * f);
      double t = brightness * (1.0 - (saturation * (1.0 - f)));
      switch ((int) h) {
      case 0:
	r = brightness; g = t; b = p;
	break;
      case 1:
	r = q; g = brightness; b = p;
	break;
      case 2:
	r = p; g = brightness; b = t;
	break;
      case 3:
	r = p; g = q; b = brightness;
	break;
      case 4:
	r = t; g = p; b = brightness;
	break;
      case 5:
	r = brightness; g = p; b = q;
	break;
      }
    }
    return new ColorExt(r,g,b,filter);
  }


  public int getRed(){
    return (int)(r*255);
  }

  public int getGreen(){
    return (int)(g*255);
  }

  public int getBlue(){
    return (int)(b*255);
  }

  protected Object clone(){
    return new ColorExt(r,g,b,f);
  }
} 

